# @copyright (c) 2002-2013 Acronis International GmbH. All rights reserved.

try:
    import ujson as __json
    dumps = __json.dumps
    loads = __json.loads
except ImportError:
    import json as __json

    def _default_encoder(o):
        def _raise_error():
            raise TypeError(repr(o) + ' is not JSON serializable')

        return getattr(o, 'toDict', _raise_error)()

    def dumps(o, **kwargs):
        return __json.dumps(o, default=_default_encoder, **kwargs)

    def loads(s, **kwargs):
        if isinstance(s, bytes):
            s = s.decode('utf8')
        return __json.loads(s, **kwargs)
